#ifndef _COMMONFUN_H
#define _COMMONFUN_H

#include "LanguageManager.h"
#include "DecCtrlClientTypes.h"
#include "resource.h"

#include <iostream>
#include <string>
using namespace std;


#define NOTIFY_SUCCESS 1
#define NOTIFY_FAILD   2

#define TYPEDEF_FUNCTION(funcName)  typedef int (__stdcall* pf##funcName)
#define DECLARE_FUNCTION(funcName)	extern pf##funcName funcName
#define IMPLEMENT_FUNCTION(funcName)  pf##funcName funcName = NULL
#define EXPORT_FUNCTION(hDll, funcName)	if(NULL == (funcName = (pf##funcName)::GetProcAddress(hDll, #funcName))){ TRACE("NVDSDK ERR %d LINE\n", __LINE__);}
#define  TYPEDEF_FUNCTION_RET(retType, funcName) typedef retType (__stdcall* pf##funcName)

#define LANG_EN     0
#define LANG_CH     1	

#define LOG_LEVEL_INFO  0
#define LOG_LEVEL_DEBUG 1
#define LOG_LEVEL_WARN  2
#define LOG_LEVEL_ERROR 3

#define MIN_SERVER_PORT	70
#define MAX_SERVER_PORT	65535

#define POS_NO_WIN		 0
#define POS_WITH_WIN     1	

#define GetTextEx(_uIDResource)\
	CLS_LanguageManager::Instance()->GetText(_uIDResource)

int IsValidIP(const char* _cIP);
CString GetText(int _iIDS);
void AddLog(int _iLevel, char * _szFmt, ...);
int EncodeBase64(char* Result,char* Source);
int DecodeBase64(char* Result, char* Source);
CString IntToStr( int _iValue );
int InsertColumn(CListCtrl& _ListCtrl,int _iColumn,LPCTSTR _strColumn, 
				 int _iFormat = LVCFMT_LEFT,int _iWidth = -1,int _iSubItem = -1);
int InsertColumn(CListCtrl& _ListCtrl,int _iColumn,unsigned int _uIDResource, 
				 int _iFormat = LVCFMT_LEFT,int _iWidth = -1,int _iSubItem = -1);
int InsertString(CComboBox& _ComboBox,int _iIndex,LPCTSTR _strItem);
int InsertString(CComboBox& _ComboBox,int _iIndex,unsigned int _uIDResource);
int CheckChannel(int iLogonId, bool* blUsedChannel, int* iChannelNum, bool* blUsedScreen, int* iScreenNum, int iCurrentChannel);
int CreateChannelCombo(int iLogonId, CComboBox* pChannelCobox);
int CreatePosCombo(int iLogonId, int iChannelNo, int iPos, CComboBox* pPosCobox, int iType);
int GetComboData(CComboBox* pCobox);
int ConvertItem(ServerItem& uItem, TNVSITEMEX* _pPara);

int SplitStringToArray(const string &_strStingSource, const string &_strSplitChar,
					   string *_strArray, int _iArraySize, const int _numberOfElements = 10240); 

typedef struct tagViewServerInfo
{	
	int  is_use;
	int  dec_ch_no;
	int  dec_pic_no;
	int  ser_index;
	char ser_name[DEC_LEN_128];
	char ser_ip[DEC_LEN_32];
	char ser_proxy[DEC_LEN_32];
	int	 ser_port;
	int  ser_ch_no;
	int  ser_stream_no;
	int  ser_net_mode;	//0:TCP, 1:UDP, 2:MUT
	int  con_mode;		//0:ip, 1:DDNS, 3:DSM
	int  hold_time;
	char ser_usr_name[DEC_LEN_64];
	char ser_usr_pwd[DEC_LEN_64];
	char ser_ptz_protocol[DEC_LEN_32];
	int  ser_ptz_addr;
	char video_dec_pwd[DEC_LEN_32];
	char rtsp_url[DEC_LEN_256 + 1];
	char mult_ip[DEC_LEN_32];
	int  mult_port;
	int	 ser_type;			//0-normal, 1-Onvif, 2-Push Stream, 3-RTSP, 4-Inner Encode Channel   5-Local Input Channel
} ViewServerInfo, *pViewServerInfo;
int ConvertItemEx(ServerItem* _puItem, int _iType, ViewServerInfo& tServer);
int ConvertSeverToItem(IN ViewServerInfo* _ptServer, OUT ServerItem* _puItem, OUT int* _piServerType);


int ConvertChannel(int _iLogonID, int _iChannelNo);
int ConvertPos(int _iLogonID, int iPoslNo);

HTREEITEM InsertItem(CTreeCtrl& _TreeCtrl,LPCTSTR _strItem,DWORD_PTR _dwData,HTREEITEM _hParent = TVI_ROOT);
HTREEITEM InsertItem(CTreeCtrl& _TreeCtrl,unsigned int _uIDResource,DWORD_PTR _dwData,HTREEITEM _hParent = TVI_ROOT);
CString GetTextByLan( CString _cstrTextCH, CString _cstrTextEn/* = ""*/ );
CString GetFormatTextByLan( CString _cstrFormatTextCH, CString _cstrFormatTextEn, ... );
#endif